/*  
  Données utilisées pour la métaphore — "niveau de batterie".
  La batterie diminue quand la consommation augmente.

  Sources officielles :
  - SDES — La consommation d’électricité des centres de données (2018–2023, France, >1 GWh/an)
    https://www.statistiques.developpement-durable.gouv.fr/la-consommation-delectricite-des-centres-de-donnees-entre-2018-et-2023

  - SDES — Chiffres clés de l’énergie (International)
    https://www.statistiques.developpement-durable.gouv.fr/edition-numerique/chiffres-cles-energie/fr/11-international

  - Polytechnique Insights — IA générative : la consommation énergétique explose
    https://www.polytechnique-insights.com/tribunes/energie/ia-generative-la-consommation-energetique-explose/

  Interprétation :
  2018 = 3,2 TWh  
  2023 = 3,9 TWh  
  → augmentation ∼ +21 %  
  → la “batterie” représente l’énergie disponible non consommée par l’IA/les DC
  → donc plus la consommation augmente, plus le niveau baisse.
*/

const levels = {
  2018: 60,  // consommation plus faible → batterie plus pleine
  2019: 56,
  2020: 52,
  2021: 45,
  2022: 40,
  2023: 35   // consommation la plus élevée → batterie plus vide
};

const levelEl = document.getElementById('level');
const select = document.getElementById('year');

function update() {
  const y = select.value;
  const p = levels[y] ?? 50;
  levelEl.style.width = p + '%';
  levelEl.setAttribute('aria-valuenow', p);
}
select.addEventListener('change', update);
update();
